/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.blazing.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.lib.varia.Sync;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.blazing.BlazingConfiguration;
import mcjty.rftoolspower.modules.blazing.BlazingModule;
import mcjty.rftoolspower.modules.blazing.items.BlazingRod;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class BlazingGeneratorTileEntity
extends TickingTileEntity {
    public static final int BUFFER_SIZE = 4;
    public static final BooleanProperty WORKING = BooleanProperty.m_61465_((String)"working");
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(4).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get())}).in(), 0, 10, 7).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get())}).in(), 1, 82, 7).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get())}).in(), 2, 10, 43).slot(SlotDefinition.specific((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)BlazingModule.BLAZING_ROD.get())}).in(), 3, 82, 43).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).slotLimit(1).itemValid(GenericItemHandler.match(BlazingModule.BLAZING_ROD)).onUpdate((slot, stack) -> this.updateSlot((int)slot)).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, false, (long)((Integer)BlazingConfiguration.GENERATOR_MAXENERGY.get()).intValue(), 0L);
    @Cap(type=CapType.INFUSABLE)
    private final IInfusable infusable = new DefaultInfusable((BlockEntity)this);
    private final int[] rfPerTickMax = new int[4];
    private final float[] rfPerTick = new float[4];
    private final int[] ticksRemaining = new int[4];
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Blazing Generator").containerSupplier(DefaultContainerProvider.container(BlazingModule.CONTAINER_BLAZING_GENERATOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).shortListener(Sync.integer(() -> (int)this.rfPerTick[0], v -> {
        this.rfPerTick[0] = v.intValue();
    })).shortListener(Sync.integer(() -> (int)this.rfPerTick[1], v1 -> {
        this.rfPerTick[1] = v1.intValue();
    })).shortListener(Sync.integer(() -> (int)this.rfPerTick[2], v2 -> {
        this.rfPerTick[2] = v2.intValue();
    })).shortListener(Sync.integer(() -> (int)this.rfPerTick[3], v3 -> {
        this.rfPerTick[3] = v3.intValue();
    })).setupSync((GenericTileEntity)this));

    public BlazingGeneratorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlazingModule.TYPE_BLAZING_GENERATOR.get(), pos, state);
    }

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().properties(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(2.0f).m_60918_(SoundType.f_56743_)).topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).infusable().manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/blazinggenerator")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold()}).tileEntitySupplier(BlazingGeneratorTileEntity::new)){

            protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
                super.m_7926_(builder);
                builder.m_61104_(new Property[]{WORKING});
            }
        };
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected void tickServer() {
        this.handleSendingEnergy();
        this.handlePowerGeneration();
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            super.setPowerInput(powered);
            for (int i = 0; i < 4; ++i) {
                this.updateSlot(i);
            }
        }
    }

    public void setRSMode(RedstoneMode redstoneMode) {
        super.setRSMode(redstoneMode);
        for (int i = 0; i < 4; ++i) {
            this.updateSlot(i);
        }
    }

    public float getRfPerTick(int slot) {
        return this.rfPerTick[slot];
    }

    private void handleSendingEnergy() {
        long storedPower = this.energyStorage.getEnergy();
        EnergyTools.handleSendingEnergy((Level)this.f_58857_, (BlockPos)this.f_58858_, (long)storedPower, (long)((Integer)BlazingConfiguration.GENERATOR_SENDPERTICK.get()).intValue(), (GenericEnergyStorage)this.energyStorage);
    }

    private void handlePowerGeneration() {
        int totalRfGenerated = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.rfPerTick[i] > (float)this.rfPerTickMax[i]) {
                int n = i;
                this.rfPerTick[n] = this.rfPerTick[n] + ((float)this.rfPerTickMax[i] - this.rfPerTick[i]) / 30.0f;
                if (this.rfPerTick[i] < (float)this.rfPerTickMax[i]) {
                    this.rfPerTick[i] = this.rfPerTickMax[i];
                }
            } else if (this.rfPerTick[i] < (float)this.rfPerTickMax[i]) {
                int n = i;
                this.rfPerTick[n] = this.rfPerTick[n] + (((float)this.rfPerTickMax[i] - this.rfPerTick[i]) / 150.0f + 0.01f);
                if (this.rfPerTick[i] > (float)this.rfPerTickMax[i]) {
                    this.rfPerTick[i] = this.rfPerTickMax[i];
                }
            }
            totalRfGenerated += (int)this.rfPerTick[i];
            if (!this.isMachineEnabled()) continue;
            int n = i;
            this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
            ItemStack stack = this.items.getStackInSlot(i);
            if (this.ticksRemaining[i] <= 0) {
                this.ticksRemaining[i] = 0;
                this.rfPerTickMax[i] = 0;
                if (stack.m_41619_()) continue;
                this.items.setStackInSlot(i, ItemStack.f_41583_);
                continue;
            }
            if (stack.m_41619_()) continue;
            BlazingRod.setPowerDuration(stack, this.ticksRemaining[i]);
        }
        this.energyStorage.produceEnergy((long)totalRfGenerated);
        boolean generating = totalRfGenerated > 0;
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if ((Boolean)state.m_61143_((Property)WORKING) != generating) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(generating)), 3);
        }
        this.markDirtyQuick();
    }

    private void updateSlot(int slot) {
        ItemStack stack = this.items.getStackInSlot(slot);
        if (stack.m_41619_() || !this.isMachineEnabled()) {
            this.rfPerTickMax[slot] = 0;
            this.ticksRemaining[slot] = 0;
        } else {
            this.rfPerTickMax[slot] = (int)((float)BlazingRod.getRfPerTick(stack) * (this.infusable.getInfusedFactor() * 0.1f + 1.0f));
            this.ticksRemaining[slot] = BlazingRod.getTotalTicks(stack);
        }
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        for (int i = 0; i < 4; ++i) {
            this.rfPerTickMax[i] = tagCompound.m_128451_("rftMax" + i);
            this.rfPerTick[i] = tagCompound.m_128457_("rft" + i);
            this.ticksRemaining[i] = tagCompound.m_128451_("ticks" + i);
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        for (int i = 0; i < 4; ++i) {
            tagCompound.m_128405_("rftMax" + i, this.rfPerTickMax[i]);
            tagCompound.m_128350_("rft" + i, this.rfPerTick[i]);
            tagCompound.m_128405_("ticks" + i, this.ticksRemaining[i]);
        }
        super.m_183515_(tagCompound);
    }
}

